/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.cf3270em;

import com.ibm.hwmca.base.cf3270em.AddEmulatorSessionBean;
import com.ibm.hwmca.base.cf3270em.Cf3270EmConstants;
import com.ibm.hwmca.base.cf3270em.Cf3270EmData;
import com.ibm.hwmca.base.cf3270em.Cf3270EmErrorIds;
import com.ibm.hwmca.base.cf3270em.Cf3270EmStartupHook;
import com.ibm.hwmca.base.cf3270em.EmulatorSessionsBean;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.persist.PersistenceManager;
import com.ibm.hwmca.fw.task.UserContext;
import com.ibm.hwmca.fw.tasklet.PanelTasklet;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.tasklet.PanelTaskletResponse;
import com.ibm.hwmca.fw.tasklet.TaskletException;
import com.ibm.hwmca.fw.util.CommonResourceBundle;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.ui.framework.TaskActionEvent;
import java.util.Locale;
import java.util.TreeMap;

public class Cf3270EmTasklet
extends PanelTasklet
implements Cf3270EmErrorIds,
Cf3270EmConstants {
    private static final String TRACE_MASKT = "XEMU   T";
    private static final String TRACE_MASKF = "XEMU   F";
    private static final String TRACE_MASKD = "XEMU   D";
    private static FrameworkClassLogInfo logInfo = new FrameworkClassLogInfo(-93, "Cf3270EmTasklet");
    private static final String AUIML = "com.ibm.hwmca.base.cf3270em.res.3270EmulatorSessions";
    private static final String PANEL = "EmulatorSessionsPanel";
    private static final String PANEL_ADD = "AddSessionPanel";
    private EmulatorSessionsBean emulatorSessionsBean = new EmulatorSessionsBean();
    private AddEmulatorSessionBean addEmulatorSessionBean = new AddEmulatorSessionBean();
    private Cf3270EmData data;

    public Cf3270EmTasklet() {
        Trace.trace(TRACE_MASKT, "[Cf3270EmTasklet] <-> Cf3270EmTasklet()");
    }

    public void init() throws TaskletException {
        Trace.trace(TRACE_MASKT, "[Cf3270EmTasklet] --> init()");
        this.emulatorSessionsBean.setBeanName("EmulatorSessionsBean");
        this.addEmulatorSessionBean.setBeanName("AddEmulatorSessionBean");
        try {
            this.data = (Cf3270EmData)PersistenceManager.getPersistenceManager().read("com.ibm.hwmca.base.cf3270em.Cf3270EmPersistentData");
            if (this.data == null) {
                this.data = new Cf3270EmData();
            }
            Locale userLocale = UserContext.getCurrentUserContext().getLocale();
            String enabled = CommonResourceBundle.getString(AUIML, userLocale, "AddSessionPanel.EnabledChoice.VALUE");
            String disabled = CommonResourceBundle.getString(AUIML, userLocale, "AddSessionPanel.DisabledChoice.VALUE");
            this.emulatorSessionsBean.setOrigSettings(this.data.getHosts(), enabled, disabled);
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "Caught exception " + e);
            Trace.trace(TRACE_MASKF, e);
            HException hexc = new HException(e);
            new FrameworkLog(logInfo, 2, hexc).log();
            throw new TaskletException("Unrecoverable Error");
        }
        Trace.trace(TRACE_MASKT, "[Cf3270EmTasklet] <-- init()");
    }

    public void service(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
        Trace.trace(TRACE_MASKT, "[Cf3270EmTasklet] --> service(" + request + ", " + response + ")");
        try {
            if (request.isInitialRequest()) {
                response.replace(AUIML, PANEL, this.emulatorSessionsBean);
            } else {
                String panelNum = (String)request.getData("Panel");
                TaskActionEvent event = (TaskActionEvent)request.getData("Event");
                if (panelNum.equals("1")) {
                    if (event == null) {
                        response.noAction();
                    } else if (event.getElementName().endsWith("OkButton")) {
                        TreeMap hosts = (TreeMap)request.getData("hosts");
                        this.data.setHosts(hosts);
                        response.terminate();
                    } else if (event.getElementName().endsWith("CancelButton")) {
                        PanelTaskletRequest panelTaskletRequest = new PanelTaskletRequest();
                        panelTaskletRequest.setDisposed();
                        response.terminate();
                    } else if (event.getElementName().endsWith("NewButton")) {
                        response.openModalChild(AUIML, PANEL_ADD, this.addEmulatorSessionBean);
                    } else if (event.getElementName().endsWith("StartButton")) {
                        String ipAddr = (String)request.getData("ipAddr");
                        Cf3270EmStartupHook.startEmulator(ipAddr);
                        response.noAction();
                    }
                } else if (event.getElementName().endsWith("Button1")) {
                    String[] selected = new String[]{(String)request.getData("HostAddressEdit"), (String)request.getData("EnabledDisabledChoice")};
                    response.setMultipleResponseMode();
                    response.dispose();
                    response.update(selected);
                } else if (event.getElementName().endsWith("Button2")) {
                    response.dispose();
                }
            }
        }
        catch (Exception e) {
            new FrameworkLog(logInfo, 3, e).log();
            throw new TaskletException("Unrecoverable Error");
        }
        Trace.trace(TRACE_MASKT, "[Cf3270EmTasklet] <-- service()");
    }

    public void logException(Throwable throwable) {
        Trace.trace(TRACE_MASKT, "[Cf3270EmTasklet] --> logException(" + throwable + ")");
        new FrameworkLog(logInfo, 1, throwable).log();
        Trace.trace(TRACE_MASKT, "[Cf3270EmTasklet] <-- logException()");
    }
}

